package com.izenpe.zain.cliente.crypt;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartEncryptRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartEncryptResponse;

public class CifradoCMS {
	
	// Nombre del fichero que vamos a Encriptar
	private static final String fileName = "Cifrado-descifrado.txt";

	public static void main(String args[]) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartEncryptRequest smartEncryptRequest = new SmartEncryptRequest(Propiedades.ZAIN_ENDPOINT);
			
			/*
			 * Se selecciona el tipo de cifrado CMS/PKCS#7
			 */
			smartEncryptRequest.setProfile(Constants.Profile.CMSPKCS7);
			
			/*
			 * Datos a cifrar
			 */
			smartEncryptRequest.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			
			/*
			 * Tipo de cifrado a realizar
			 */
			smartEncryptRequest.setEncryptionType(Constants.EncryptionType.CMS);
			
			/*
			 * Escoge el recipient o destinatario para ese cifrado, seleccionndolo a partir de su nombre distintivo
			 */
			smartEncryptRequest.setKeySubjectName(Propiedades.RECIPIENT_DN);
			
			
			// Envo de la peticin.
			SmartEncryptResponse smartEncryptResponse = smartEncryptRequest.send();
			
			if (Constantes.RMAJOR_SUCCESS.equals((smartEncryptResponse.getResultMajor()))
					&& smartEncryptResponse.getResultMinor() == null) {
				//Guardamos los datos encriptados
				String encryptBase64 = smartEncryptResponse.getEnvelopeBase64();
				byte[] data = Base64.decode(encryptBase64);
				String destFilename = "data/input/" + fileName + ".cms";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("Encryption OK");
			} else {
				System.out.println("Error durante el Cifrado: " + smartEncryptResponse.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}